import { MessageSerializer } from "../serializer";
import { MessageDeserializer } from "../deserializer";
export class zappar_client {
    constructor(_messageSender) {
        this._messageSender = _messageSender;
        this._globalState = {
            log_level: 1,
        };
        this.serializer = new MessageSerializer(ab => {
            this._messageSender(ab);
        });
        this.deserializer = new MessageDeserializer();
        this._latestId = 1;
        this._pipeline_state_by_instance = new Map();
        this._camera_source_state_by_instance = new Map();
        this._sequence_source_state_by_instance = new Map();
        this._image_tracker_state_by_instance = new Map();
        this._face_tracker_state_by_instance = new Map();
        this._face_mesh_state_by_instance = new Map();
        this._face_landmark_state_by_instance = new Map();
        this._barcode_finder_state_by_instance = new Map();
        this._instant_world_tracker_state_by_instance = new Map();
        this._zapcode_tracker_state_by_instance = new Map();
        this._world_tracker_state_by_instance = new Map();
        this._custom_anchor_state_by_instance = new Map();
        this._d3_tracker_state_by_instance = new Map();
        this.impl = {
            log_level: () => {
                return this._globalState.log_level;
            },
            log_level_set: (level) => {
                this.serializer.sendMessage(39, m => {
                    m.logLevel(level);
                });
            },
            analytics_project_id_set: (id, uid) => {
                this.serializer.sendMessage(36, m => {
                    m.string(id);
                    m.string(uid);
                });
            },
            // #### pipeline ####
            pipeline_create: () => {
                let newId = (this._latestId++);
                let s = {
                    current_frame_user_data: 0,
                    camera_model: new Float32Array([300, 300, 160, 120, 0, 0]),
                    camera_data_width: 320,
                    camera_data_height: 240,
                    camera_frame_sharpness_enabled: false,
                    camera_frame_sharpness: -1,
                    camera_pose: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    camera_frame_camera_attitude: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    camera_frame_device_attitude: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    frame_number: 0,
                };
                this._pipeline_state_by_instance.set(newId, s);
                this.serializer.sendMessage(32, m => {
                    m.type(newId);
                });
                return newId;
            },
            pipeline_destroy: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._pipeline_state_by_instance.delete(o);
                this.serializer.sendMessage(33, m => {
                    m.type(o);
                });
            },
            pipeline_frame_update: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(9, m => {
                    m.type(o);
                });
            },
            pipeline_frame_number: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.frame_number;
            },
            pipeline_camera_model: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_model;
            },
            pipeline_camera_data_width: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_data_width;
            },
            pipeline_camera_data_height: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_data_height;
            },
            pipeline_camera_frame_sharpness_enabled: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_frame_sharpness_enabled;
            },
            pipeline_camera_frame_sharpness_enabled_set: (o, val) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(63, m => {
                    m.type(o);
                    m.bool(val);
                });
                s.camera_frame_sharpness_enabled = val;
            },
            pipeline_camera_frame_sharpness: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_frame_sharpness;
            },
            pipeline_camera_frame_user_data: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.current_frame_user_data;
            },
            pipeline_camera_frame_submit: (o, data, width, height, user_data, camera_to_device_transform, camera_model, user_facing, timestampMicroseconds) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(8, m => {
                    m.type(o);
                    m.dataWithLength(data);
                    m.int(width);
                    m.int(height);
                    m.int(user_data);
                    m.matrix4x4(camera_to_device_transform);
                    m.cameraModel(camera_model);
                    m.bool(user_facing);
                    m.int(timestampMicroseconds);
                });
            },
            pipeline_camera_frame_camera_attitude: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_frame_camera_attitude;
            },
            pipeline_camera_frame_device_attitude: (o) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.camera_frame_device_attitude;
            },
            pipeline_motion_accelerometer_submit: (o, time, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(10, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_accelerometer_with_gravity_submit_int: (o, time, interval, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(12, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.timestamp(interval);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_accelerometer_without_gravity_submit_int: (o, time, interval, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(11, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.timestamp(interval);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_rotation_rate_submit: (o, time, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(15, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_rotation_rate_submit_int: (o, time, interval, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(13, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.timestamp(interval);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_attitude_submit: (o, time, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(16, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_attitude_submit_int: (o, time, interval, x, y, z) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(14, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.timestamp(interval);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                });
            },
            pipeline_motion_relative_orientation_submit_int: (o, time, interval, x, y, z, w) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(17, m => {
                    m.type(o);
                    m.timestamp(time);
                    m.timestamp(interval);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                    m.float(w);
                });
            },
            pipeline_motion_attitude_matrix_submit: (o, mat) => {
                let s = this._pipeline_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(18, m => {
                    m.type(o);
                    m.matrix4x4(mat);
                });
            },
            // #### camera_source ####
            camera_source_create: (pipeline, device_id) => {
                let newId = (this._latestId++);
                let s = {};
                this._camera_source_state_by_instance.set(newId, s);
                this.serializer.sendMessage(34, m => {
                    m.type(newId);
                    m.type(pipeline);
                    m.string(device_id);
                });
                return newId;
            },
            camera_source_destroy: (o) => {
                let s = this._camera_source_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._camera_source_state_by_instance.delete(o);
                this.serializer.sendMessage(35, m => {
                    m.type(o);
                });
            },
            // #### sequence_source ####
            sequence_source_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {};
                this._sequence_source_state_by_instance.set(newId, s);
                this.serializer.sendMessage(40, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            sequence_source_destroy: (o) => {
                let s = this._sequence_source_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._sequence_source_state_by_instance.delete(o);
                this.serializer.sendMessage(41, m => {
                    m.type(o);
                });
            },
            // #### image_tracker ####
            image_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    target_loaded_version: -1,
                    anchor_count: 0,
                    anchor_id: [],
                    anchor_pose: [],
                };
                this._image_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(2, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            image_tracker_destroy: (o) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._image_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(19, m => {
                    m.type(o);
                });
            },
            image_tracker_target_load_from_memory: (o, data) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(4, m => {
                    m.type(o);
                    m.dataWithLength(data);
                });
            },
            image_tracker_target_loaded_version: (o) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.target_loaded_version;
            },
            image_tracker_enabled: (o) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            image_tracker_enabled_set: (o, enabled) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(3, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            image_tracker_anchor_count: (o) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_count;
            },
            image_tracker_anchor_id: (o, indx) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_id[indx];
            },
            image_tracker_anchor_pose_raw: (o, indx) => {
                let s = this._image_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_pose[indx];
            },
            // #### face_tracker ####
            face_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    model_loaded: -1,
                    max_faces: 1,
                    anchor_count: 0,
                    anchor_id: [],
                    anchor_pose: [],
                    anchor_identity_coefficients: [],
                    anchor_expression_coefficients: [],
                };
                this._face_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(25, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            face_tracker_destroy: (o) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._face_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(26, m => {
                    m.type(o);
                });
            },
            face_tracker_model_load_from_memory: (o, data) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(27, m => {
                    m.type(o);
                    m.dataWithLength(data);
                });
            },
            face_tracker_model_loaded_version: (o) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.model_loaded;
            },
            face_tracker_enabled_set: (o, enabled) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(28, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            face_tracker_enabled: (o) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            face_tracker_max_faces_set: (o, num) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(29, m => {
                    m.type(o);
                    m.int(num);
                });
                s.max_faces = num;
            },
            face_tracker_max_faces: (o) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.max_faces;
            },
            face_tracker_anchor_count: (o) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_count;
            },
            face_tracker_anchor_id: (o, indx) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_id[indx];
            },
            face_tracker_anchor_pose_raw: (o, indx) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_pose[indx];
            },
            face_tracker_anchor_identity_coefficients: (o, indx) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_identity_coefficients[indx];
            },
            face_tracker_anchor_expression_coefficients: (o, indx) => {
                let s = this._face_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_expression_coefficients[indx];
            },
            // #### face_mesh ####
            face_mesh_create: () => {
                let newId = (this._latestId++);
                let s = {};
                this._face_mesh_state_by_instance.set(newId, s);
                this.serializer.sendMessage(30, m => {
                    m.type(newId);
                });
                return newId;
            },
            face_mesh_destroy: (o) => {
                let s = this._face_mesh_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._face_mesh_state_by_instance.delete(o);
                this.serializer.sendMessage(31, m => {
                    m.type(o);
                });
            },
            // #### face_landmark ####
            face_landmark_create: (landmark) => {
                let newId = (this._latestId++);
                let s = {};
                this._face_landmark_state_by_instance.set(newId, s);
                this.serializer.sendMessage(37, m => {
                    m.type(newId);
                    m.faceLandmarkName(landmark);
                });
                return newId;
            },
            face_landmark_destroy: (o) => {
                let s = this._face_landmark_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._face_landmark_state_by_instance.delete(o);
                this.serializer.sendMessage(38, m => {
                    m.type(o);
                });
            },
            // #### barcode_finder ####
            barcode_finder_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    number_found: 0,
                    found_text: [],
                    found_format: [],
                    formats: (1 << 17) - 1,
                };
                this._barcode_finder_state_by_instance.set(newId, s);
                this.serializer.sendMessage(21, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            barcode_finder_destroy: (o) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._barcode_finder_state_by_instance.delete(o);
                this.serializer.sendMessage(22, m => {
                    m.type(o);
                });
            },
            barcode_finder_enabled_set: (o, enabled) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(23, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            barcode_finder_enabled: (o) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            barcode_finder_found_number: (o) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.number_found;
            },
            barcode_finder_found_text: (o, indx) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.found_text[indx];
            },
            barcode_finder_found_format: (o, indx) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.found_format[indx];
            },
            barcode_finder_formats: (o) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.formats;
            },
            barcode_finder_formats_set: (o, f) => {
                let s = this._barcode_finder_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(24, m => {
                    m.type(o);
                    m.barcodeFormat(f);
                });
                s.formats = f;
            },
            // #### instant_world_tracker ####
            instant_world_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    pose: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                };
                this._instant_world_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(5, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            instant_world_tracker_destroy: (o) => {
                let s = this._instant_world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._instant_world_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(20, m => {
                    m.type(o);
                });
            },
            instant_world_tracker_enabled_set: (o, enabled) => {
                let s = this._instant_world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(6, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            instant_world_tracker_enabled: (o) => {
                let s = this._instant_world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            instant_world_tracker_anchor_pose_raw: (o) => {
                let s = this._instant_world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.pose;
            },
            instant_world_tracker_anchor_pose_set_from_camera_offset_raw: (o, x, y, z, orientation) => {
                let s = this._instant_world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(7, m => {
                    m.type(o);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                    m.instantTrackerTransformOrientation(orientation);
                });
            },
            // #### zapcode_tracker ####
            zapcode_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    target_loaded_version: -1,
                    anchor_count: 0,
                    anchor_id: [],
                    anchor_pose: [],
                };
                this._zapcode_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(42, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            zapcode_tracker_destroy: (o) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._zapcode_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(45, m => {
                    m.type(o);
                });
            },
            zapcode_tracker_target_load_from_memory: (o, data) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(44, m => {
                    m.type(o);
                    m.dataWithLength(data);
                });
            },
            zapcode_tracker_target_loaded_version: (o) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.target_loaded_version;
            },
            zapcode_tracker_enabled: (o) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            zapcode_tracker_enabled_set: (o, enabled) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(43, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            zapcode_tracker_anchor_count: (o) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_count;
            },
            zapcode_tracker_anchor_id: (o, indx) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_id[indx];
            },
            zapcode_tracker_anchor_pose_raw: (o, indx) => {
                let s = this._zapcode_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.anchor_pose[indx];
            },
            // #### world_tracker ####
            world_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    enabled: true,
                    session_number: 0,
                    horizontal_plane_detection_enabled: true,
                    vertical_plane_detection_enabled: false,
                    plane_anchor_count: 0,
                    plane_anchor_pose: [],
                    plane_anchor_status: [],
                    plane_anchor_polygon_version: [],
                    plane_anchor_polygon_data: [],
                    plane_anchor_polygon_data_size: [],
                    plane_anchor_id: [],
                    plane_anchor_orientation: [],
                    world_anchor_status: 0,
                    world_anchor_pose: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    world_anchor_id: '',
                    ground_anchor_status: 0,
                    ground_anchor_pose: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    ground_anchor_id: '',
                    tracks_data_enabled: false,
                    tracks_data: new Float32Array([]),
                    tracks_data_size: 0,
                    tracks_type_data: new Uint8Array([]),
                    tracks_type_data_size: 0,
                    projections_data_enabled: false,
                    projections_data: new Float32Array([]),
                    projections_data_size: 0,
                    scale_mode: 0,
                    quality: 3,
                };
                this._world_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(46, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            world_tracker_destroy: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._world_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(47, m => {
                    m.type(o);
                });
            },
            world_tracker_enabled: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.enabled;
            },
            world_tracker_enabled_set: (o, enabled) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(48, m => {
                    m.type(o);
                    m.bool(enabled);
                });
                s.enabled = enabled;
            },
            world_tracker_scale_mode: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.scale_mode;
            },
            world_tracker_scale_mode_set: (o, scale_mode) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(62, m => {
                    m.type(o);
                    m.worldScaleMode(scale_mode);
                });
                s.scale_mode = scale_mode;
            },
            world_tracker_session_number: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.session_number;
            },
            world_tracker_quality: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.quality;
            },
            world_tracker_horizontal_plane_detection_enabled: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.horizontal_plane_detection_enabled;
            },
            world_tracker_horizontal_plane_detection_enabled_set: (o, horizontal_plane_detection_enabled) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(49, m => {
                    m.type(o);
                    m.bool(horizontal_plane_detection_enabled);
                });
                s.horizontal_plane_detection_enabled = horizontal_plane_detection_enabled;
            },
            world_tracker_vertical_plane_detection_enabled: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.vertical_plane_detection_enabled;
            },
            world_tracker_vertical_plane_detection_enabled_set: (o, vertical_plane_detection_enabled) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(50, m => {
                    m.type(o);
                    m.bool(vertical_plane_detection_enabled);
                });
                s.vertical_plane_detection_enabled = vertical_plane_detection_enabled;
            },
            world_tracker_plane_anchor_count: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_count;
            },
            world_tracker_plane_anchor_id: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_id[indx];
            },
            world_tracker_plane_anchor_pose_raw: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_pose[indx];
            },
            world_tracker_plane_anchor_status: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_status[indx];
            },
            world_tracker_plane_anchor_polygon_data_size: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_polygon_data_size[indx];
            },
            world_tracker_plane_anchor_polygon_data: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_polygon_data[indx];
            },
            world_tracker_plane_anchor_polygon_version: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_polygon_version[indx];
            },
            world_tracker_plane_anchor_orientation: (o, indx) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.plane_anchor_orientation[indx];
            },
            world_tracker_world_anchor_status: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.world_anchor_status;
            },
            world_tracker_world_anchor_id: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.world_anchor_id;
            },
            world_tracker_world_anchor_pose_raw: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.world_anchor_pose;
            },
            world_tracker_ground_anchor_id: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.ground_anchor_id;
            },
            world_tracker_ground_anchor_status: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.ground_anchor_status;
            },
            world_tracker_ground_anchor_pose_raw: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.ground_anchor_pose;
            },
            world_tracker_reset: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(51, m => {
                    m.type(o);
                });
            },
            world_tracker_tracks_data_enabled: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.tracks_data_enabled;
            },
            world_tracker_tracks_data_enabled_set: (o, tracks_data_enabled) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(52, m => {
                    m.type(o);
                    m.bool(tracks_data_enabled);
                });
                s.tracks_data_enabled = tracks_data_enabled;
            },
            world_tracker_tracks_data_size: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.tracks_data_size;
            },
            world_tracker_tracks_data: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.tracks_data;
            },
            world_tracker_tracks_type_data_size: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.tracks_type_data_size;
            },
            world_tracker_tracks_type_data: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.tracks_type_data;
            },
            world_tracker_projections_data_enabled: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.projections_data_enabled;
            },
            world_tracker_projections_data_enabled_set: (o, projections_data_enabled) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(53, m => {
                    m.type(o);
                    m.bool(projections_data_enabled);
                });
                s.projections_data_enabled = projections_data_enabled;
            },
            world_tracker_projections_data_size: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.projections_data_size;
            },
            world_tracker_projections_data: (o) => {
                let s = this._world_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.projections_data;
            },
            // #### custom_anchor ####
            custom_anchor_create: (pipeline, worldtracker, id) => {
                let newId = (this._latestId++);
                let s = {
                    pose: new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]),
                    status: 3,
                    pose_version: 0,
                };
                this._custom_anchor_state_by_instance.set(newId, s);
                this.serializer.sendMessage(54, m => {
                    m.type(newId);
                    m.type(pipeline);
                    m.type(worldtracker);
                    m.string(id);
                });
                return newId;
            },
            custom_anchor_destroy: (o) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._custom_anchor_state_by_instance.delete(o);
                this.serializer.sendMessage(55, m => {
                    m.type(o);
                });
            },
            custom_anchor_status: (o) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.status;
            },
            custom_anchor_pose_version: (o) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.pose_version;
            },
            custom_anchor_pose_raw: (o) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                return s.pose;
            },
            custom_anchor_pose_set_from_camera_offset_raw: (o, x, y, z, orientation) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(56, m => {
                    m.type(o);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                    m.transformOrientation(orientation);
                });
            },
            custom_anchor_pose_set_from_anchor_offset: (o, anchor_id, x, y, z, orientation) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(57, m => {
                    m.type(o);
                    m.string(anchor_id);
                    m.float(x);
                    m.float(y);
                    m.float(z);
                    m.transformOrientation(orientation);
                });
            },
            custom_anchor_pose_set: (o, pose) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(58, m => {
                    m.type(o);
                    m.matrix4x4(pose);
                });
            },
            custom_anchor_pose_set_with_parent: (o, pose, anchor_id) => {
                let s = this._custom_anchor_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this.serializer.sendMessage(59, m => {
                    m.type(o);
                    m.matrix4x4(pose);
                    m.string(anchor_id);
                });
            },
            // #### d3_tracker ####
            d3_tracker_create: (pipeline) => {
                let newId = (this._latestId++);
                let s = {
                    id: [],
                    enabled: true,
                    count: 0,
                    qr: [],
                    pose: [],
                    type: [],
                    dense: [],
                    category: [],
                    process_max_resolution: false,
                };
                this._d3_tracker_state_by_instance.set(newId, s);
                this.serializer.sendMessage(60, m => {
                    m.type(newId);
                    m.type(pipeline);
                });
                return newId;
            },
            d3_tracker_destroy: (o) => {
                let s = this._d3_tracker_state_by_instance.get(o);
                if (!s)
                    throw new Error("This object has been destroyed");
                this._d3_tracker_state_by_instance.delete(o);
                this.serializer.sendMessage(61, m => {
                    m.type(o);
                });
            },
        };
    }
    processMessages(a) {
        this.deserializer.setData(a);
        this.deserializer.forMessages((messageId, msg) => {
            switch (messageId) {
                case 10: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.frame_number = msg.int();
                    break;
                }
                case 6: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_model = msg.cameraModel();
                    break;
                }
                case 7: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_data_width = msg.int();
                    break;
                }
                case 8: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_data_height = msg.int();
                    break;
                }
                case 9: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_frame_sharpness = msg.float();
                    break;
                }
                case 5: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.current_frame_user_data = msg.int();
                    break;
                }
                case 14: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_frame_camera_attitude = msg.matrix4x4();
                    break;
                }
                case 15: {
                    let handle = msg.type();
                    let inst = this._pipeline_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.camera_frame_device_attitude = msg.matrix4x4();
                    break;
                }
                case 22: {
                    let handle = msg.type();
                    let inst = this._image_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.target_loaded_version = msg.int();
                    break;
                }
                case 1: {
                    let handle = msg.type();
                    let inst = this._image_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.anchor_count = msg.int();
                    break;
                }
                case 2: {
                    let handle = msg.type();
                    let inst = this._image_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_id[indx] = msg.string();
                    break;
                }
                case 3: {
                    let handle = msg.type();
                    let inst = this._image_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_pose[indx] = msg.matrix4x4();
                    break;
                }
                case 21: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.model_loaded = msg.int();
                    break;
                }
                case 16: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.anchor_count = msg.int();
                    break;
                }
                case 17: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_id[indx] = msg.string();
                    break;
                }
                case 18: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_pose[indx] = msg.matrix4x4();
                    break;
                }
                case 19: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_identity_coefficients[indx] = msg.identityCoefficients();
                    break;
                }
                case 20: {
                    let handle = msg.type();
                    let inst = this._face_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_expression_coefficients[indx] = msg.expressionCoefficients();
                    break;
                }
                case 11: {
                    let handle = msg.type();
                    let inst = this._barcode_finder_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.number_found = msg.int();
                    break;
                }
                case 12: {
                    let handle = msg.type();
                    let inst = this._barcode_finder_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.found_text[indx] = msg.string();
                    break;
                }
                case 13: {
                    let handle = msg.type();
                    let inst = this._barcode_finder_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.found_format[indx] = msg.barcodeFormat();
                    break;
                }
                case 4: {
                    let handle = msg.type();
                    let inst = this._instant_world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.pose = msg.matrix4x4();
                    break;
                }
                case 27: {
                    let handle = msg.type();
                    let inst = this._zapcode_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.target_loaded_version = msg.int();
                    break;
                }
                case 24: {
                    let handle = msg.type();
                    let inst = this._zapcode_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.anchor_count = msg.int();
                    break;
                }
                case 25: {
                    let handle = msg.type();
                    let inst = this._zapcode_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_id[indx] = msg.string();
                    break;
                }
                case 26: {
                    let handle = msg.type();
                    let inst = this._zapcode_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.anchor_pose[indx] = msg.matrix4x4();
                    break;
                }
                case 28: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.session_number = msg.int();
                    break;
                }
                case 44: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.quality = msg.int();
                    break;
                }
                case 29: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.plane_anchor_count = msg.int();
                    break;
                }
                case 37: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_id[indx] = msg.string();
                    break;
                }
                case 30: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_pose[indx] = msg.matrix4x4();
                    break;
                }
                case 32: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_status[indx] = msg.anchorStatus();
                    break;
                }
                case 33: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_polygon_data_size[indx] = msg.int();
                    break;
                }
                case 34: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_polygon_data[indx] = msg.floatArray();
                    break;
                }
                case 35: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_polygon_version[indx] = msg.int();
                    break;
                }
                case 36: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    let indx = msg.int();
                    inst.plane_anchor_orientation[indx] = msg.planeOrientation();
                    break;
                }
                case 40: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.world_anchor_status = msg.anchorStatus();
                    break;
                }
                case 39: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.world_anchor_id = msg.string();
                    break;
                }
                case 38: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.world_anchor_pose = msg.matrix4x4();
                    break;
                }
                case 42: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.ground_anchor_id = msg.string();
                    break;
                }
                case 43: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.ground_anchor_status = msg.anchorStatus();
                    break;
                }
                case 41: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.ground_anchor_pose = msg.matrix4x4();
                    break;
                }
                case 47: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.tracks_data_size = msg.int();
                    break;
                }
                case 46: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.tracks_data = msg.floatArray();
                    break;
                }
                case 49: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.tracks_type_data_size = msg.int();
                    break;
                }
                case 48: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.tracks_type_data = msg.ucharArray();
                    break;
                }
                case 52: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.projections_data_size = msg.int();
                    break;
                }
                case 51: {
                    let handle = msg.type();
                    let inst = this._world_tracker_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.projections_data = msg.floatArray();
                    break;
                }
                case 54: {
                    let handle = msg.type();
                    let inst = this._custom_anchor_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.status = msg.anchorStatus();
                    break;
                }
                case 55: {
                    let handle = msg.type();
                    let inst = this._custom_anchor_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.pose_version = msg.int();
                    break;
                }
                case 53: {
                    let handle = msg.type();
                    let inst = this._custom_anchor_state_by_instance.get(handle);
                    if (!inst)
                        return;
                    inst.pose = msg.matrix4x4();
                    break;
                }
            }
        });
    }
}
