import { anchor_status_t, world_tracker_quality_t } from './gen/zappar-native';
import { UvLayout } from './yuv-conversion-gl';
export interface WTData {
    session_number?: number;
    world_anchor_status: anchor_status_t;
    world_anchor_pose: Float32Array | number[];
    ground_anchor_status: anchor_status_t;
    ground_anchor_pose: Float32Array | number[];
    plane_anchors: PlaneAnchorData[];
    custom_anchors: CustomAnchorData[];
    mesh_anchors: MeshAnchorData[];
    quality: world_tracker_quality_t;
}
export interface PlaneAnchorData {
    id: string;
    horizontal: boolean;
    status: anchor_status_t;
    pose: Float32Array | number[];
    boundary: Float32Array | number[];
    boundaryVersion: number;
}
export interface CustomAnchorData {
    id: number;
    status: anchor_status_t;
    pose: Float32Array | number[];
    poseVersion: number;
}
export interface D3Data {
    worldToCamera: Float32Array | number[];
    detections: D3Detection[];
}
export interface D3Detection {
    id: string;
    type: number;
    qr?: string;
    dense?: number;
    category?: number;
    worldPoses: (Float32Array | number[])[];
    landmarks: Float32Array | number[];
    scale: number;
}
export interface MeshAnchorData {
    id: string;
    pose: Float32Array | number[];
    status: anchor_status_t;
    vertices: {
        binaryOffset: number;
        binaryLength: number;
        offset: number;
        stride: number;
        count: number;
        format: number;
        componentsPerVector: number;
    };
    indices: {
        binaryOffset: number;
        binaryLength: number;
        bytesPerIndex: number;
        indexCountPerPrimitive: number;
        count: number;
        primitiveType: number;
    };
}
export interface BridgedMessage {
    frameNo: number;
    cameraModel: Float32Array | [number, number, number, number, number, number];
    dataWidth: number;
    dataHeight: number;
    dataBinaryBufferOffset: number;
    dataBinaryBufferLength: number;
    yWidth: number;
    yHeight: number;
    uvWidth: number;
    uvHeight: number;
    uvLayout?: UvLayout;
    previewBinaryBufferOffset: number;
    previewBinaryBufferLength: number;
    wtData: WTData;
    d3Data?: D3Data;
}
