/// <reference types="gl-matrix/index.js" />
import { quat, vec3 } from 'gl-matrix';
import { Object3D } from '@wonderlandengine/api';
/**
 * Absolute rotation around an axis.
 *
 * @param out Result.
 * @param axis Axis to rotate around. Should be normalized.
 * @param target Normalized origin to target vector, used to compute the rotation.
 */
export declare const rotateAroundPivot: (out: quat, axis: vec3, target: vec3) => quat;
/**
 * LookAt with quaternions.
 *
 * @param out Result.
 * @param source Source position
 * @param target Target position
 * @param up Up vector
 */
export declare const rotateFreeDual: (out: quat, source: vec3, target: vec3, up: vec3) => import("gl-matrix").vec4;
export declare const computeLocalPositionForPivot: (out: vec3, target: Object3D, position: vec3) => vec3;
