var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
import { vec3 } from 'gl-matrix';
const tempVec1 = vec3.create();
const tempVec2 = vec3.create();
/**
 * This component helps retrieve the camera position in VR and non-VR.
 */
export class ActiveCamera extends Component {
    static TypeName = 'active-camera';
    nonVrCamera;
    leftEye;
    rightEye;
    /**
     * Based on the current XR session (is VR active or not), returns the active camera.
     * @returns The active camera.
     */
    get current() {
        return this.engine.xr ? this.leftEye : this.nonVrCamera;
    }
    getForwardWorld(out) {
        const object = this.engine.xr ? this.leftEye : this.nonVrCamera;
        return object.getForwardWorld(out);
    }
    /**
     * Depending on the current XR session (is VR active or not),
     * returns the position of the active camera. For VR this is the average
     * of the left and right eye.
     * @param position The position to write the result to.
     * @returns The world position of the active camera.
     */
    getPositionWorld(out = vec3.create()) {
        if (!this.engine.xr) {
            return this.nonVrCamera.getPositionWorld(out);
        }
        const cameraPosition = tempVec1;
        const rightEyePosition = tempVec2;
        this.leftEye.getPositionWorld(cameraPosition);
        this.rightEye.getPositionWorld(rightEyePosition);
        vec3.add(cameraPosition, cameraPosition, rightEyePosition);
        return vec3.scale(out, cameraPosition, 0.5);
    }
}
__decorate([
    property.object({ required: true })
], ActiveCamera.prototype, "nonVrCamera", void 0);
__decorate([
    property.object({ required: true })
], ActiveCamera.prototype, "leftEye", void 0);
__decorate([
    property.object({ required: true })
], ActiveCamera.prototype, "rightEye", void 0);
