import { Component, Object3D } from '@wonderlandengine/api';
import { vec3 } from 'gl-matrix';
/**
 * This component helps retrieve the camera position in VR and non-VR.
 */
export declare class ActiveCamera extends Component {
    static TypeName: string;
    nonVrCamera: Object3D;
    leftEye: Object3D;
    rightEye: Object3D;
    /**
     * Based on the current XR session (is VR active or not), returns the active camera.
     * @returns The active camera.
     */
    get current(): Object3D;
    getForwardWorld(out: vec3): vec3;
    /**
     * Depending on the current XR session (is VR active or not),
     * returns the position of the active camera. For VR this is the average
     * of the left and right eye.
     * @param position The position to write the result to.
     * @returns The world position of the active camera.
     */
    getPositionWorld(out?: vec3): vec3;
}
