export class TrackingMode {
    component;
    provider;
    constructor(provider, component) {
        this.component = component;
        this.provider = provider;
    }
}
/**
 * Face attachment point enum
 *
 * Values are sorted by position on the face from top to bottom,
 * as these will appear in the Wonderland Editor in this order.
 */
export var FaceAttachmentPoint;
(function (FaceAttachmentPoint) {
    FaceAttachmentPoint["Forehead"] = "forehead";
    FaceAttachmentPoint["EyeOuterCornerLeft"] = "eye outer corner left";
    FaceAttachmentPoint["EyeOuterCornerRight"] = "eye outer corner right";
    FaceAttachmentPoint["EyeBrowInnerLeft"] = "eyebrow inner left";
    FaceAttachmentPoint["EyeBrowInnerRight"] = "eyebrow inner right";
    FaceAttachmentPoint["EyeBrowCenterLeft"] = "eyebrow center left";
    FaceAttachmentPoint["EyeBrowCenterRight"] = "eyebrow center right";
    FaceAttachmentPoint["EyeBrowOuterLeft"] = "eyebrow outer left";
    FaceAttachmentPoint["EyeBrowOuterRight"] = "eyebrow outer right";
    FaceAttachmentPoint["EarLeft"] = "ear left";
    FaceAttachmentPoint["EarRight"] = "ear right";
    FaceAttachmentPoint["EyeLeft"] = "eye left";
    FaceAttachmentPoint["EyeRight"] = "eye right";
    FaceAttachmentPoint["NoseBridge"] = "nose bridge";
    FaceAttachmentPoint["NoseTip"] = "nose tip";
    FaceAttachmentPoint["CheekLeft"] = "cheek left";
    FaceAttachmentPoint["CheekRight"] = "cheek right";
    FaceAttachmentPoint["Mouth"] = "mouth";
    FaceAttachmentPoint["MouthCornerLeft"] = "mouth corner left";
    FaceAttachmentPoint["MouthCornerRight"] = "mouth corner right";
    FaceAttachmentPoint["UpperLip"] = "upper lip";
    FaceAttachmentPoint["LowerLip"] = "lower lip";
    FaceAttachmentPoint["Chin"] = "chin";
})(FaceAttachmentPoint || (FaceAttachmentPoint = {}));
