import { ARSession } from '../AR-session.js';
import { ARCamera } from './AR-Camera.js';
export class ARTrackingCameraBase extends ARCamera {
    _trackingImpl;
    _registeredWithSession = false;
    _readyReported = false;
    init() {
        const arSession = ARSession.getSessionForEngine(this.engine);
        if (!this._registeredWithSession) {
            arSession.registerARCameraComponent();
            this._registeredWithSession = true;
        }
        this._trackingImpl = arSession.getTrackingProvider(this.getTrackingType(), this);
    }
    getTrackingInitFeatures() {
        return undefined;
    }
    validateStart() { }
    start() {
        this.validateStart();
        if (this._trackingImpl.init) {
            this._trackingImpl.init(this.getTrackingInitFeatures());
        }
        if (!this._readyReported) {
            ARSession.getSessionForEngine(this.engine).markARCameraReady();
            this._readyReported = true;
        }
    }
    startSession = () => {
        if (this.active) {
            this._trackingImpl.startSession();
        }
    };
    endSession = () => {
        if (this.active) {
            this._trackingImpl.endSession();
        }
    };
    onDeactivate() {
        this._trackingImpl.endSession();
    }
    update(dt) {
        this._trackingImpl.update?.(dt);
        const cameraTransformWorld = this._trackingImpl.getCameraTransformWorld?.();
        if (cameraTransformWorld) {
            this.object.setTransformWorld(cameraTransformWorld);
        }
    }
}
