var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { property } from '@wonderlandengine/api/decorators.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR image tracking Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Currently only works with 8th Wall tracking `WorldTracking_XR8`
 */
export class ARImageTrackingCamera extends ARTrackingCameraBase {
    static TypeName = 'ar-image-tracking-camera';
    static InheritProperties = true;
    getTrackingType() {
        return TrackingType.Image;
    }
    enableSLAM;
    get onImageScanning() {
        return this._trackingImpl.onImageScanning;
    }
    get onImageFound() {
        return this._trackingImpl.onImageFound;
    }
    get onImageUpdate() {
        return this._trackingImpl.onImageUpdate;
    }
    get onImageLost() {
        return this._trackingImpl.onImageLost;
    }
    /**
     * Pre-registers an image tracking target with the active provider.
     *
     * Delegates to {@link ImageTrackingMode.registerTarget} if the provider
     * implements it (e.g. Zappar requires `.zpt` files to be loaded before
     * tracking starts). Providers that do not need pre-registration will
     * silently ignore this call.
     *
     * Call from a response component's `start()` hook, passing the same
     * `name` that the component uses as its `imageId`.
     *
     * @param source URL or `ArrayBuffer` of the target file.
     * @param options.name Must match the `imageId` on tracker components.
     * @param options.physicalWidthInMeters Optional physical width in metres.
     */
    async registerTarget(source, options) {
        await this._trackingImpl.registerTarget?.(source, options);
    }
}
__decorate([
    property.bool(false) // Improves tracking, reduces performance
], ARImageTrackingCamera.prototype, "enableSLAM", void 0);
