var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { property } from '@wonderlandengine/api/decorators.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR face tracking Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Currently only works with 8th Wall tracking `FaceTracking_XR8`
 */
export class ARFaceTrackingCamera extends ARTrackingCameraBase {
    static TypeName = 'ar-face-tracking-camera';
    static InheritProperties = true;
    getTrackingType() {
        return TrackingType.Face;
    }
    cameraDirection;
    get onFaceLoading() {
        return this._trackingImpl.onFaceLoading;
    }
    get onFaceFound() {
        return this._trackingImpl.onFaceFound;
    }
    get onFaceUpdate() {
        return this._trackingImpl.onFaceUpdate;
    }
    get onFaceLost() {
        return this._trackingImpl.onFaceLost;
    }
    validateStart() {
        if (!this.object.getComponent('view')) {
            throw new Error('AR-camera requires a view component');
        }
    }
}
__decorate([
    property.enum(['front', 'back'], 'front')
], ARFaceTrackingCamera.prototype, "cameraDirection", void 0);
