import { ITrackingMode, HitTestResult } from '../tracking-mode.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR SLAM Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Depending on the device it will choose to use either device native WebXR (`WebXRProvider`)
 * or 8th Wall SLAM implementation (`xr8Provider`)
 */
export declare class ARSLAMCamera extends ARTrackingCameraBase<ITrackingMode> {
    static TypeName: string;
    protected getTrackingType(): TrackingType;
    private readonly _projectionMatrix;
    update(dt: number): void;
    /**
     * Set up a hit-test source for the current tracking provider.
     *
     * Delegates to the underlying tracking mode's {@link ITrackingMode.setupHitTest}
     * implementation. Providers that do not require explicit setup are a no-op.
     */
    setupHitTest(): Promise<void>;
    /** Release any hit-test resources. Called automatically on session end. */
    teardownHitTest(): void;
    /**
     * Returns the current hit-test result (a world-space surface position
     * directly in front of the camera), or `null` when no surface is found.
     *
     * Should be called each frame from a reticle / placement component.
     */
    getHitTestResult(): HitTestResult | null;
}
