import { Emitter } from '@wonderlandengine/api';
/**
 * ARProvider defines the core behavior how an AR provider should look like.
 * AR provider should handle the loading, configuring and starting/stopping some tracking implementation.
 * For example src/components/AR/frameworks/xr8/xr8-provider.ts loads, configures and checks the required permissions for the 8th Wall library.
 */
class ARProvider {
    _engine;
    get engine() {
        return this._engine;
    }
    /**
     * Whether this provider can start tracking without an explicit user gesture
     * (e.g. without entering a WebXR immersive session).
     *
     * Providers like Zappar can run in a normal page and should return true.
     */
    get supportsInstantTracking() {
        return false;
    }
    constructor(engine) {
        this._engine = engine;
    }
    /**
     * onSessionStart - array of callbacks to be called when the tracking implementation has started tracking.
     * It is NOT necessary called immediately after startSession is called
     */
    onSessionStart = new Emitter();
    /**
     * onSessionEnd - array of callbacks to be called when the tracking implementation has stoped tracking.
     * It is NOT necessary called immediately after endSession is called
     */
    onSessionEnd = new Emitter();
    // Tracking implementation has beed loaded
    loaded = false;
}
export { ARProvider };
