import { Component } from '@wonderlandengine/api';
import { quat2 } from 'gl-matrix';
import { ARSession } from '@wonderlandengine/ar-tracking';
import { ZapparProvider } from './zappar-provider.js';
/**
 * Applies Zappar Instant World Tracking anchor pose to this object.
 *
 * Attach this component to a parent object of your content to verify/visualize
 * the anchor pose coming from Zappar.
 */
export class SlamAnchorZappar extends Component {
    static TypeName = 'slam-anchor-zappar';
    _provider = null;
    _tmpTransform = quat2.create();
    start() {
        const arSession = ARSession.getSessionForEngine(this.engine);
        arSession.onSessionStart.add(this.onSessionStart);
        arSession.onSessionEnd.add(this.onSessionEnd);
        // If a session is already running, RetainEmitter will call immediately.
    }
    update() {
        const provider = this._provider;
        if (!provider)
            return;
        const anchorPose = provider.slamAnchorPoseMatrix;
        if (!anchorPose)
            return;
        // Zappar matrices are column-major; gl-matrix expects column-major.
        quat2.fromMat4(this._tmpTransform, anchorPose);
        this.object.setTransformWorld(this._tmpTransform);
    }
    onSessionStart = (provider) => {
        this._provider = provider instanceof ZapparProvider ? provider : null;
    };
    onSessionEnd = (provider) => {
        if (provider === this._provider)
            this._provider = null;
    };
}
