/**
 * Hit-test reticle backed by Zappar plane anchors from `WorldTracker`
 * (requires `@zappar/zappar >= 4.x`).
 *
 * Each frame the component casts a ray from the centre of `camera` into the
 * set of planes detected by {@link ZapparProvider}'s `WorldTracker` and moves
 * the owning object to the closest intersection point.  A {@link MeshComponent}
 * on the same object is shown while a valid hit is found and hidden otherwise.
 *
 * This is the Zappar equivalent of:
 * - `hit-test-location-root`  (WebXR Device API hit-test)
 * - `hit-test-location-xr8`   (8th Wall SLAM + XY-plane intersection)
 *
 * **Setup**
 * 1. Attach this component to the reticle object (which should have a
 *    {@link MeshComponent} for visual feedback).
 * 2. Set the `camera` property to the scene object that carries
 *    {@link ARSLAMCamera}.
 * 3. The `SpawnMeshOnReticle` component works alongside this component –
 *    tapping the screen (or selecting on WebXR) will spawn content at this
 *    object's position.
 *
 * **Coordinate spaces**
 * Zappar plane poses are expressed in Zappar world space.  The WLE camera
 * object's transform is driven directly from the Zappar camera pose matrix
 * (via `WorldTracking_Zappar`), so `camera.getPositionWorld()` and
 * `camera.getForwardWorld()` are already in the same coordinate space as the
 * plane poses.  No additional transform is required.
 */
import { Component, Object as WLEObject } from '@wonderlandengine/api';
export declare class HitTestLocationZappar extends Component {
    static TypeName: string;
    /** The scene object that carries the {@link ARSLAMCamera} component. */
    camera: WLEObject;
    private _provider;
    private _mesh;
    private readonly _camPos;
    private readonly _camFwd;
    private readonly _planeNormal;
    private readonly _planeOrigin;
    private readonly _toOrigin;
    private readonly _hitPoint;
    start(): void;
    update(): void;
    private readonly _onSessionStart;
    private readonly _onSessionEnd;
}
