import { Emitter } from '@wonderlandengine/api';
import { FaceAttachmentPoint, FaceFoundEvent, FaceLoadingEvent, FaceLostEvent, FaceTrackingMode, TrackingMode } from '@wonderlandengine/ar-tracking';
type AttachmentMapping = Partial<Record<FaceAttachmentPoint, string>>;
export declare const AttachmentLandmarkKeys: AttachmentMapping;
export declare function buildFaceLoadingEventFromMesh(maxDetections: number, verticesArray: ArrayLike<number>, indicesArray: ArrayLike<number>, uvsArray: ArrayLike<number>): FaceLoadingEvent;
export declare class FaceTracking_Zappar extends TrackingMode implements FaceTrackingMode {
    private _zappar;
    private _view?;
    private _faceTracker?;
    private _faceMesh?;
    private _resourcesReady;
    private _resourcesPromise;
    private readonly _landmarks;
    private readonly _sharedLandmarks;
    private readonly _anchorNumericIds;
    private _nextAnchorId;
    private readonly _cameraMatrix;
    private readonly _cameraPosition;
    private readonly _cameraRotation;
    private readonly _cameraScale;
    private readonly _scratchMatrix;
    private readonly _scratchPosition;
    private readonly _scratchRotation;
    private readonly _scratchScale;
    private readonly _providerRotation;
    private _loadingEvent;
    readonly onFaceScanning: Emitter<[event: FaceLoadingEvent]>;
    readonly onFaceLoading: Emitter<[event: FaceLoadingEvent]>;
    readonly onFaceFound: Emitter<[event: FaceFoundEvent]>;
    readonly onFaceUpdate: Emitter<[event: FaceFoundEvent]>;
    readonly onFaceLost: Emitter<[event: FaceLostEvent]>;
    init(): void;
    startSession(): void;
    endSession(): void;
    update(): void;
    private _prepareResources;
    private _buildLandmarks;
    private _buildLoadingEvent;
    private _handleAnchorVisible;
    private _handleAnchorNotVisible;
    private _buildFaceEvent;
    private _applyCameraPose;
    private _setProjectionMatrixWithEngineRemap;
    private _anchorNumericId;
}
export {};
