import { ImageLike } from '../types.js';
/**
 * Check if a given value is a native string or a `String` instance.
 *
 * @param value The value to check.
 * @returns `true` if the `value` has type string literal or `String`, `false` otherwise.
 */
export declare function isString(value: any): value is string;
/**
 * Check if a given value is a native number or a `Number` instance.
 *
 * @param value The value to check.
 * @returns `true` if the `value` has type number literal or `Number`, `false` otherwise.
 */
export declare function isNumber(value: any): value is number;
/**
 * Check whether a given value is a visual media.
 *
 * @param value The value to check
 * @returns `true` if the `value` is an image, video, or canvas.
 */
export declare function isImageLike(value: any): value is ImageLike;
