import { WonderlandEngine } from '../engine.js';
import { ParticleEffect, ParticleEffectParameters } from '../wonderland.js';
import { ResourceManager } from './resource.js';
/**
 * Manage particle effects.
 *
 * #### Creation
 *
 * Creating a particle effect is done using {@link ParticleEffectManager.create}:
 *
 * ```js
 * const particleEffect = engine.particleEffects.create({maxCount: 10, mesh: myMesh, material: myMaterial});
 * ```
 *
 * @since 1.5.0
 */
export declare class ParticleEffectManager extends ResourceManager<ParticleEffect> {
    constructor(engine: WonderlandEngine);
    /**
     * Create a new particle effect.
     *
     * @param params Particle effect settings. For more information, have a
     *     look at the {@link ParticleEffectParameters} object.
     */
    create(params: Partial<ParticleEffectParameters>): ParticleEffect;
}
