import { WonderlandEngine } from '../engine.js';
import { Pipeline } from '../wonderland.js';
import { ResourceManager } from './resource.js';
/**
 * Manage pipelines.
 *
 * #### Retrieval
 *
 * Retrieving a pipeline by name is done using {@link PipelineManager.findByName}:
 *
 * @since 1.5.1
 */
export declare class PipelineManager extends ResourceManager<Pipeline> {
    constructor(engine: WonderlandEngine);
    /**
     * Find pipeline by name.
     *
     * @param name Pipeline to find.
     * @returns The pipeline instance or `null` if no such pipeline could be found.
     */
    findByName(name: string): Pipeline | null;
}
