## 1.5.0

WebGPU support with full WebGL2 feature parity, probe volume scenarios,
runtime baking, audio resources, and particle effect JS API.

### WebGPU support

Wonderland 1.4.x had experimental WebGPU support, but we've upgraded
the WebGPU backend to support all features of the existing WebGL2
renderer.

WebGPU is now a first-class target for web applications in
Wonderland. Try it out in your favorite browser! If WebGPU is not
supported, Wonderland automatically falls back to WebGL2 with no
visual difference.

The focus of this release was visual feature parity, but expect
to see many performance and visual improvements as we make more and
more use of WebGPU's modern API.

### Probe volume scenarios

Probe volumes are a great way to get baked global illumination into your
project. However, managing multiple lighting scenarios (e.g. different season
or time of day) involved manually moving around files.

This is now a thing of the past! You can now create multiple probe volume
scenario resources, and then pick which scenario should be baked and which
should be used for global illumination.

### Changelog

**Editor**

- Add new probe volume scenario resource
- Split probe volume voxelization and baking. You can now see the voxelization
  result before baking.
- Make probe volume baking cancellable. If restarted, resumes from where it
  was cancelled.
- Speed up scene voxelization for probe volume baking
- Allow selecting WebGPU-only as rendering API
- Make shadow map size configurable, clamped at runtime to supported size
- Show more fine-grained GPU timings in the Profile view
- Optimize Scene View debug visualization rendering
- Allow switching between projects in a workspace from the Scene Outline
- Fix some cases of stale data after switching projects
- Rework undo/redo to work correctly when switching projects
- Display a popup when a project fails to load
- Add project file export and import. Exporting creates a new .wlp with the
  selected objects and all referenced resources. Importing merges an exported
  .wlp into the current project.
- Add new Particle Effect resource. Can currently be used from the new
  `ParticleEffectComponent` JS component for programmatically creating effects.
  A no-code effect creation UI is planned for a future version.
- Add new Audio Clip resource. Audio files will get deployed as separate files
  alongside the packaged .bin.
- Allow filtering collision and physics debug visualization in Scene View to
  selected objects only
- Add Install button to Plugin view for simple installation of bundled plugins
- Add `loadUncompressedImagesAsBitmap` runtime setting for loading uncompressed
  images as `ImageBitmap` (instead of `HTMLImageElement` etc.)
- Add `deferSkinningCompilation` rendering setting to defer skinning shader
  compilation to their first use
- Fall back correctly to `importPhysicalAsPhongMaterials` editor setting on
  older projects
- Fix regression when dropping assets onto objects
- Convert material colors to sRGB if necessary
- Minimize shader recompilations on pipeline changes
- Handle animations with an empty track list
- Reset all transforms when disabling animation preview
- Eliminate race condition while compressing images
- Fix undo of an operation that created a resource
- Use correct offset when scroll-to-bottom is active in Console view
- Improve path handling for projects on different Windows drives
- Make file watching more robust on all operating systems
- Handle some invalid component edge cases more gracefully
- React to changes to app.js and index.js
- Fix a rare crash when editing text inputs with large strings
- Fix crash when toggling `enableRuntimeGltf`
- Fix several webserver-related crashes
- Enable crash handling in --windowless mode
- Add "Replace references" tool in Resource View

**Engine**

- Implement WebGPU rendering backend with full feature parity
- Avoid superfluous skinned mesh updates with multidraw enabled
- Package probe volume scenarios as delay-loaded .bin files
- Fix morph targets sometimes targeting the wrong mesh
- Initialize cloned animation components without skins
- Eliminate artifacts on Meta Quest when enabling usePreZ
- Use albedo alpha value for Physical shader output
- Add `CLEARCOAT` feature to Physical shader for rendering glossy transparent
  materials like car paint
- Render multiple-scattering in Physical shader with environment probes
- Optimize Physical shader for mobile GPUs
- Skip some vertex shader work for meshes with scaling 0
- Improve skinning shader compatibility with some older mobile GPUs
- Fix several browser warnings

**Runtime**

- Bundle all WebGPU-enabled variants of the runtime
- Use correct threaded runtime when WebGPU is enabled
- Fall back to WebGL2 runtime if WebGPU is not supported or initialization fails
- Use multithreading for glTF loading to reduce hitching and improve performance
  when loading multiple files. Can be toggled via `GLTFOptions.async`.
- Pass embedded glTF image blobs directly to the browser for decoding, skipping
  expensive base64 conversion
- Add support for WebXR layers. Enable by requesting the `layers` WebXR feature.
- Use `WEBGL_multisampled_render_to_texture` with WebXR layers on Meta Quest
- Fix collider visualization

**Editor API**

- Rename `project` to `workspace`
- Add `workspace.projects[]` for accessing per-project data
- Add `tools.saveProject()`
- Add `tools.getComponentTypes()`
- Add `ui.inputTextPassword()`
- Add several missing type declarations
- Eliminate editor hang when calling `tools.packageProject()`
- Fix wrong values returned from `tools.computeMeshBounds()`
- Fix deletion of referenced resources crashing the editor
- Hide some non-enumerable properties

**JS API**

- Add `Environment.requestBake()` for baking environment from the current sky material
- Add `GLTFOptions.generateSimpleTangents` to generate trivial tangents instead
  of using mikktspace. Speeds up loading, but might produce rendering artifacts.
- Add new `ParticleEffectComponent` for spawning and rendering instanced particle effects
- Add new `ParticleEffect` resource
- Add new `AudioClip` resource
- Add `Resource.origin` to get the scene a resource was loaded from
- Add `ResourceManager.loadedFromScene()` to query all resources loaded from a given scene
- Add `ResourceManager.all()` to query all alive resources
- Add `Prefab.destroyResources()` for destroying all resources loaded from a scene
- Add `AnimationGraphManager` for creating 1D-blend graphs from multiple animations
- Add `AnimationGraph.setPlaybackSpeed()` for controlling playback speed of
  individual animation graph samplers
- Add `ViewComponent.getDirectionForScreenPosition()` to get a view-space
  direction for a set of canvas coordinates (e.g. for raycasting mouse clicks)
- Add `visualize` setting to `CollisionComponent` and `PhysXComponent` to control
  the debug visualization visibility per component
- Make toggling `LightComponent.shadows` actually update shadow rendering
- Fix `ViewComponent.getViewport()` returning invalid data
