var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
import { quat2 } from 'gl-matrix';
/**
 * Prints some limited debug information about the object.
 *
 * Information consists of: This object's name, an object parameter's name,
 * the object's world translation, world transform and local transform.
 *
 * Mainly used by engine developers for debug purposes or as example code.
 */
class DebugObject extends Component {
    static TypeName = 'debug-object';
    /** A second object to print the name of */
    obj = null;
    start() {
        let origin = new Float32Array(3);
        quat2.getTranslation(origin, this.object.transformWorld);
        console.log('Debug object:', this.object.name);
        console.log('Other object:', this.obj?.name);
        console.log('\ttranslation', origin);
        console.log('\ttransformWorld', this.object.transformWorld);
        console.log('\ttransformLocal', this.object.transformLocal);
    }
}
__decorate([
    property.object()
], DebugObject.prototype, "obj", void 0);
export { DebugObject };
//# sourceMappingURL=debug-object.js.map