import { Prefab } from '../prefab.js';
import { AnimationGraph, Animation } from '../wonderland.js';
import { ResourceManager } from './resource.js';
/**
 * Manage animation graphs.
 *
 * #### Creation
 *
 * Creating an animation graph with a one dimensional
 * blend tree is done using {@link AnimationGraphManager.blend1D}
 *
 * @since 1.4.7
 */
export declare class AnimationGraphManager extends ResourceManager<AnimationGraph> {
    constructor(scene: Prefab);
    /**
     * Generate an animation graph that blends between
     * a list of animation in 1 dimension.
     *
     * #### Usage
     *
     * ```js
     * const graph = engine.animationsGraphs.blend1D([idle, walk, run]);
     * object.getComponent(AnimationComponent).animation = graph;
     * ```
     *
     * @note All animations must have the same number of tracks
     * and only the first animation has to be retargeted to the object/skin.
     *
     * @param anims Array of anims to blend.
     * @returns The new animation graph.
     */
    blend1D(anims: Animation[]): AnimationGraph;
}
