#ifndef WGSL_WGPU
diagnostic(off,derivative_uniformity);
#endif

#include "lib/Compatibility.wgsl"

#define FEATURE_TEXTURED
#define FEATURE_ALPHA
#define FEATURE_ALPHA_MASKED
#define FEATURE_VERTEX_COLORS

#ifdef TEXTURED
#define USE_TEXTURE_COORDS
#endif
#ifdef VERTEX_COLORS
#define USE_COLOR
#endif

#define USE_MATERIAL_ID

#ifdef TEXTURED
#include "lib/Textures.wgsl"
#endif
#include "lib/Materials.wgsl"

struct Material {
    color: vec4<f8>,
#ifdef TEXTURED
    flatTexture: u16,
#endif
}

fn decodeMaterial(matIndex: u32) -> Material {
    {{decoder}}
    return mat;
}

@fragment
fn main(
#include "lib/Inputs.wgsl"
) -> @location(0) vec4<f32> {
    #ifdef TEXTURED
    alphaMask(fragMaterialId, fragTextureCoords);
    #endif

    let mat: Material = decodeMaterial(fragMaterialId);
    let outColor: vec4<f32> =
        #ifdef VERTEX_COLORS
        fragColor +
        #endif
        #ifdef TEXTURED
        textureAtlas(mat.flatTexture, fragTextureCoords)*
        #endif
        mat.color;
    return outColor;
}
