const CacheName = '{{ settings.project.name }}-static-v1';
const files = [{{ precacheFiles }}];

self.addEventListener('install', event => {
    event.waitUntil(caches.open(CacheName).then(cache => cache.addAll(files) ));
});
self.addEventListener('activate', () => {
    console.log('Service worker initialized.');
});

self.addEventListener('fetch', e => {
    e.respondWith(
        (async () => {
            const r = await caches.match(e.request, {ignoreSearch: true});
            if (r) return r;

            const response = await fetch(e.request);
            const cache = await caches.open(CacheName);
            cache.put(e.request, response.clone());
            return response;
        })()
    );
});
