var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
import { quat } from 'gl-matrix';
const preventDefault = (e) => { e.preventDefault(); };
const TEMP_ROT = new Float32Array(4);
const ROT_MUL = 180 / Math.PI / 100;
/**
 * Controls the camera orientation through mouse movement.
 *
 * Efficiently implemented to affect object orientation only
 * when the mouse moves.
 */
class MouseLookComponent extends Component {
    static TypeName = 'mouse-look';
    /** Mouse look sensitivity */
    sensitity = 0.25;
    /** Require a mouse button to be pressed to control view.
     * Otherwise view will allways follow mouse movement */
    requireMouseDown = true;
    /** If "moveOnClick" is enabled, mouse button which should
     * be held down to control view */
    mouseButtonIndex = 0;
    /** Enables pointer lock on "mousedown" event on canvas */
    pointerLockOnClick = false;
    currentRotationY = 0;
    currentRotationX = 0;
    mouseDown = false;
    onActivate() {
        document.addEventListener('mousemove', this.onMouseMove);
        const canvas = this.engine.canvas;
        if (this.pointerLockOnClick) {
            canvas.addEventListener('mousedown', this.requestPointerLock);
        }
        if (this.requireMouseDown) {
            if (this.mouseButtonIndex === 2) {
                canvas.addEventListener('contextmenu', preventDefault, false);
            }
            canvas.addEventListener('mousedown', this.onMouseDown);
            canvas.addEventListener('mouseup', this.onMouseUp);
        }
    }
    onDeactivate() {
        document.removeEventListener('mousemove', this.onMouseMove);
        const canvas = this.engine.canvas;
        if (this.pointerLockOnClick) {
            canvas.removeEventListener('mousedown', this.requestPointerLock);
        }
        if (this.requireMouseDown) {
            if (this.mouseButtonIndex === 2) {
                canvas.removeEventListener('contextmenu', preventDefault, false);
            }
            canvas.removeEventListener('mousedown', this.onMouseDown);
            canvas.removeEventListener('mouseup', this.onMouseUp);
        }
    }
    requestPointerLock = () => {
        const canvas = this.engine.canvas;
        canvas.requestPointerLock =
            canvas.requestPointerLock ||
                canvas.mozRequestPointerLock ||
                canvas.webkitRequestPointerLock;
        canvas.requestPointerLock();
    };
    onMouseDown = (e) => {
        if (e.button === this.mouseButtonIndex) {
            this.mouseDown = true;
            document.body.style.cursor = 'grabbing';
            if (e.button === 1) {
                e.preventDefault();
                /* Prevent scrolling */
                return false;
            }
        }
    };
    onMouseUp = (e) => {
        if (e.button === this.mouseButtonIndex) {
            this.mouseDown = false;
            document.body.style.cursor = 'initial';
        }
    };
    onMouseMove = (e) => {
        if (this.active && (this.mouseDown || !this.requireMouseDown)) {
            this.currentRotationX += (-this.sensitity * e.movementY) * ROT_MUL;
            this.currentRotationY += (-this.sensitity * e.movementX) * ROT_MUL;
            // 89 deg instead of 90 so that there are no camera glitches
            // when looking straight down/up
            this.currentRotationX = Math.max(-89, Math.min(89, this.currentRotationX));
            quat.fromEuler(TEMP_ROT, this.currentRotationX, this.currentRotationY, 0);
            this.object.setRotationLocal(TEMP_ROT);
        }
    };
}
__decorate([
    property.float(0.25)
], MouseLookComponent.prototype, "sensitity", void 0);
__decorate([
    property.bool(true)
], MouseLookComponent.prototype, "requireMouseDown", void 0);
__decorate([
    property.int()
], MouseLookComponent.prototype, "mouseButtonIndex", void 0);
__decorate([
    property.bool(false)
], MouseLookComponent.prototype, "pointerLockOnClick", void 0);
export { MouseLookComponent };
//# sourceMappingURL=mouse-look.js.map